﻿Imports System.IO
Imports System.Windows.Resources
Imports Petzold.Phone.Silverlight

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private snippets As New List(Of String)()
    Private snippetsIndex As Integer = 0


    Public Sub New()
        InitializeComponent()

        AppbarBackButton = TryCast(Me.ApplicationBar.Buttons(0), ApplicationBarIconButton)
        AppbarNextButton = TryCast(Me.ApplicationBar.Buttons(1), ApplicationBarIconButton)

        ReadXamlSnippets()
        DisplayNextSnippet()
    End Sub


    Private Sub ReadXamlSnippets()
        Dim streamInfo = Application.GetResourceStream(New Uri("Data/XamlSnippets.xml",
                                                               UriKind.Relative))
        Dim _stream = streamInfo.Stream

        Using xmlReader As XmlReader = xmlReader.Create(_stream)
            xmlReader.Read()
            xmlReader.ReadStartElement("XamlSnippets")

            Do While xmlReader.ReadToFollowing("Snippet")
                Dim strInp = xmlReader.ReadInnerXml()
                Dim strReader As New StringReader(strInp)
                Dim strWriter As New StringWriter()
                Dim strLine As String
                Dim strUnIndent As String = Nothing

                strLine = strReader.ReadLine()
                Do While Nothing IsNot strLine
                    If strUnIndent Is Nothing Then
                        If strLine.Trim().Length = 0 Then
                            strLine = strReader.ReadLine()
                            Continue Do
                        End If

                        Dim unIndent = strLine.Length - strLine.TrimStart().Length
                        strUnIndent = New String(" "c, unIndent)
                    End If

                    If strLine.StartsWith(strUnIndent) Then
                        strLine = strLine.Substring(strUnIndent.Length)
                    End If

                    strWriter.WriteLine(strLine)
                    strLine = strReader.ReadLine()
                Loop
                snippets.Add(strWriter.ToString())
            Loop
        End Using
    End Sub


    Private Sub OnXamlCruncherTextBoxXamlResult(ByVal sender As Object, ByVal args As XamlCruncherEventArgs)
        If args.Error IsNot Nothing Then
            statusText.Text = args.Error
        Else
            container.Child = args.Element
            statusText.Text = "OK"
        End If
    End Sub


    Private Sub OnAppbarBackClick(ByVal sender As Object, ByVal args As EventArgs)
        snippetsIndex -= 1
        DisplayNextSnippet()
    End Sub


    Private Sub OnAppbarNextClick(ByVal sender As Object, ByVal args As EventArgs)
        snippetsIndex += 1
        DisplayNextSnippet()
    End Sub


    Private Sub DisplayNextSnippet()
        txtbox.Text = snippets(snippetsIndex)

        AppbarNextButton.IsEnabled = snippetsIndex < snippets.Count - 1
        AppbarBackButton.IsEnabled = snippetsIndex > 0
    End Sub
End Class
